<?php
require 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$is_admin = isset($_SESSION['is_admin']) ? $_SESSION['is_admin'] : false;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Dashboard - SourceHub</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 20px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .nav-links a, .nav-links button {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            background: none;
            font-size: 14px;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .btn-logout {
            background: #e74c3c;
            color: white;
        }
        
        .btn-logout:hover {
            background: #c0392b;
        }
        
        .user-welcome {
            color: white;
            font-weight: bold;
            background: #667eea;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1 {
            color: white;
            margin-bottom: 30px;
        }
        
        .dashboard-panel {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 30px;
        }
        
        .dashboard-panel h2 {
            color: #2c3e50;
            margin-bottom: 20px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 15px;
        }
        
        .dashboard-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .dashboard-table th {
            background: #f8f9fa;
            color: #2c3e50;
            padding: 15px;
            text-align: left;
            font-weight: bold;
            border-bottom: 2px solid #ecf0f1;
        }
        
        .dashboard-table td {
            padding: 15px;
            border-bottom: 1px solid #ecf0f1;
        }
        
        .dashboard-table tr:hover {
            background: #f8f9fa;
        }
        
        .status-success {
            background: #d5f4e6;
            color: #27ae60;
            padding: 6px 12px;
            border-radius: 3px;
            font-weight: bold;
            display: inline-block;
        }
        
        .status-pending {
            background: #fef5e7;
            color: #f39c12;
            padding: 6px 12px;
            border-radius: 3px;
            font-weight: bold;
            display: inline-block;
        }
        
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 5px;
            font-size: 13px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #7f8c8d;
        }
        
        .empty-state a {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
        }
        
        footer {
            background: #2c3e50;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }
        
        @media (max-width: 768px) {
            .dashboard-table {
                font-size: 13px;
            }
            
            .dashboard-table th,
            .dashboard-table td {
                padding: 10px;
            }
            
            nav {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav-links {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <a href="dashboard.php">Dashboard</a>
                <?php if ($is_admin): ?>
                    <a href="admin.php" style="color: #f39c12; font-weight: bold;">🔒 Admin</a>
                <?php endif; ?>
                <span class="user-welcome">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <button class="btn-logout" onclick="window.location.href='logout.php'">Logout</button>
            </div>
        </nav>
    </header>

    <div class="container">
        <h1>📊 My Dashboard</h1>
        
        <div class="dashboard-panel">
            <h2>My Purchases</h2>
            <table class="dashboard-table">
                <thead>
                    <tr>
                        <th>Project Name</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Purchase Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $orders = $conn->query("
                        SELECT o.*, p.title, p.id as project_id FROM orders o 
                        JOIN projects p ON o.project_id = p.id 
                        WHERE o.user_id = $user_id 
                        ORDER BY o.created_at DESC
                    ");
                    
                    if ($orders->num_rows > 0):
                        while ($order = $orders->fetch_assoc()):
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($order['title']); ?></td>
                        <td><strong>$<?php echo number_format($order['amount'], 2); ?></strong></td>
                        <td>
                            <?php if ($order['status'] == 'SUCCESS'): ?>
                                <span class="status-success">✓ Success</span>
                            <?php else: ?>
                                <span class="status-pending">⏳ Pending</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('M d, Y h:i A', strtotime($order['created_at'])); ?></td>
                        <td>
                            <a href="project.php?id=<?php echo $order['project_id']; ?>" class="btn">View</a>
                        </td>
                    </tr>
                    <?php 
                        endwhile;
                    else:
                    ?>
                    <tr>
                        <td colspan="5">
                            <div class="empty-state">
                                <p>No purchases yet!</p>
                                <p><a href="projects.php">Browse projects</a> to get started</p>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <footer>
        <p>&copy; 2024 SourceHub - Digital Projects Marketplace. All rights reserved.</p>
    </footer>
</body>
</html>
